/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.manager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.tacz.guns.GunMod;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.manager.INetworkCacheReloadListener;
import com.tacz.guns.resource.network.DataType;
import com.tacz.guns.util.ResourceScanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;

public class AttachmentsTagManager
extends SimplePreparableReloadListener<Map<ResourceLocation, List<JsonElement>>>
implements INetworkCacheReloadListener {
    private final Map<ResourceLocation, Set<String>> tags = Maps.newHashMap();
    private final Map<ResourceLocation, Set<String>> allow_attachments = Maps.newHashMap();
    private final Gson gson = CommonAssetsManager.GSON;
    private final Marker marker = MarkerManager.getMarker((String)"AllowTagManager");
    private final FileToIdConverter fileToIdConverter = FileToIdConverter.m_246568_((String)"tacz_tags/attachments");
    protected Map<ResourceLocation, String> networkCache;

    @NotNull
    protected Map<ResourceLocation, List<JsonElement>> prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        return ResourceScanner.scanDirectoryAll(pResourceManager, this.fileToIdConverter, this.gson);
    }

    protected void apply(Map<ResourceLocation, List<JsonElement>> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.tags.clear();
        this.allow_attachments.clear();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ResourceLocation, List<JsonElement>> entry : pObject.entrySet()) {
            ResourceLocation id = entry.getKey();
            ArrayList<String> temp = new ArrayList<String>();
            for (JsonElement element : entry.getValue()) {
                try {
                    List<String> data = this.parseJson(element);
                    if (data == null) continue;
                    if (data.stream().anyMatch(Objects::isNull)) {
                        throw new JsonParseException("Null value found in JSON data");
                    }
                    temp.addAll(data);
                }
                catch (JsonParseException e) {
                    GunMod.LOGGER.error(this.marker, "Failed to parse data file {}", (Object)id, (Object)e);
                }
            }
            if (id.m_135815_().startsWith("allow_attachments/") && id.m_135815_().length() > 18) {
                ResourceLocation gunId = id.m_247449_(id.m_135815_().substring(18));
                this.allow_attachments.computeIfAbsent(gunId, v -> Sets.newHashSet()).addAll(temp);
            } else {
                this.tags.computeIfAbsent(id, v -> Sets.newHashSet()).addAll(temp);
            }
            builder.put((Object)entry.getKey(), (Object)this.gson.toJson(temp));
        }
        this.networkCache = builder.build();
    }

    private List<String> parseJson(JsonElement element) {
        return (List)this.gson.fromJson(element, (TypeToken)new TypeToken<List<String>>(){});
    }

    @Override
    public Map<ResourceLocation, String> getNetworkCache() {
        return this.networkCache;
    }

    @Override
    public DataType getType() {
        return DataType.ATTACHMENT_TAGS;
    }

    public Set<String> getAttachmentTags(ResourceLocation registryName) {
        return this.tags.get(registryName);
    }

    public Set<String> getAllowAttachmentTags(ResourceLocation registryName) {
        return this.allow_attachments.get(registryName);
    }
}

